<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Usertag;

use Erlage\Photogram\System;
use Erlage\Photogram\Data\Models\InterfaceModelBuilder;
use Erlage\Photogram\Data\Tables\Post\PostUserTagTable;

final class PostUserTagBuilder implements InterfacePostUserTagSetter, InterfaceModelBuilder
{
    /**
     * setter interface
     */
    use TraitPostUserTagSetters;

    /*
    |--------------------------------------------------------------------------
    | default values
    |--------------------------------------------------------------------------
    */

    /**
     * @var array
     */
    public $defaultValues;

    public function __construct()
    {
        $this -> defaultValues = self::defaultValues();
    }

    public static function defaultValues(): array
    {
        return array(
            PostUserTagTable::TAGGED_USER_ID     => '',
            PostUserTagTable::TAGGED_IN_POST_ID  => '',
            PostUserTagTable::POST_OWNER_USER_ID => '',

            PostUserTagTable::STAMP_REGISTRATION => System::isoDateTime(),
            PostUserTagTable::STAMP_LAST_UPDATE  => System::isoDateTime(),
        );
    }

    public function dispense(): PostUserTagModel
    {
        return PostUserTagModel::createFromData(
            array(
                // tagged user id

                PostUserTagTable::TAGGED_USER_ID => $this -> taggedUserId

                ?? $this -> defaultValues[PostUserTagTable::TAGGED_USER_ID],

                // tagged in post id

                PostUserTagTable::TAGGED_IN_POST_ID  => $this -> taggedInPostId

                ?? $this -> defaultValues[PostUserTagTable::TAGGED_IN_POST_ID],

                // post owner user id

                PostUserTagTable::POST_OWNER_USER_ID => $this -> postOwnerUserId

                ?? $this -> defaultValues[PostUserTagTable::POST_OWNER_USER_ID],

                // stamp registration

                PostUserTagTable::STAMP_REGISTRATION => $this -> stampRegistration

                ?? $this -> defaultValues[PostUserTagTable::STAMP_REGISTRATION],

                // stamp last update

                PostUserTagTable::STAMP_LAST_UPDATE  => $this -> stampLastUpdate

                ?? $this -> defaultValues[PostUserTagTable::STAMP_LAST_UPDATE],
            )
        );
    }
}
